/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	SharkCharmer
**
** DESCRIPTION:	Shark charmer puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SHARKCHARMER_H
#define SHARKCHARMER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int SharkCharmer_c_iChanceOfJumpSuccess = 20;
const ldwPoint SharkCharmer_c_sClamPos(1800, 235);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSharkCharmer : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
		bool	m_bHasBanishedSharksForever;
	};

	//class data
	bool		m_bHasBanishedSharksForever;

	//class methods
	//setup
	public:		CSharkCharmer(void);
	public:		void Reset();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool HasBanishedSharksForever() const;
	public:		void Complete();


};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSharkCharmer		SharkCharmer;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/